<?php
//Change store_id value for your store id number
$store_id = 1;
//csv_filepath is the name of your csv file with your subscribers data in this case my file has the name "subscribers.csv"
//subscribers.csv without index name
/*
1,"first@email.com"
2,"second@email.com"
..
..
*/
$csv_filepath = "subscribers.csv";
//email_csv_column_index stand for the number of the row that has the email
//row[1],row[2]
//1,2
$email_csv_column_index = 1;
$csv_delimiter = ',';
$csv_enclosure = '"';
$magento_path = __DIR__;

require "{$magento_path}/app/Mage.php";
Mage::app()->setCurrentStore($store_id);

$fp = fopen($csv_filepath, "r");
if (!$fp) die("{$csv_filepath} not found\n");
while (($row = fgetcsv($fp, 0, $csv_delimiter, $csv_enclosure)) !== false) {
	$email = trim($row[$email_csv_column_index]);
	if (strlen($email) == 0) continue;
	echo "$email";
	
	$subscriber = Mage::getModel('newsletter/subscriber')->loadByEmail($email);
	if ($subscriber->getId()) {
		echo " already subscribed\n";
		continue;
	}
	
	Mage::getModel('newsletter/subscriber')->setImportMode(true)->subscribe($email);
	echo " ok\n";
}

echo "Import finished\n";