def sort_lists(a, b)
  list = (a + b).sort
  [list[0...a.size], list[a.size..-1]]
end

require 'minitest/autorun'

class TestSortLists < Minitest::Test
  def test_sort_lists
    data = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'].shuffle
    assert_equal([['a', 'b', 'c', 'd'], ['e', 'f', 'g', 'h']], sort_lists(data[0..3], data[4..7]))
  end

  def test_sort_differ_size_lists
    data = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'].shuffle
    assert_equal([['a', 'b'], ['c', 'd', 'e', 'f', 'g', 'h']], sort_lists(data[0..1], data[2..7]))
  end
end